(function() {
	var win = window,
		doc = document,
		proto = 'prototype',
		head = doc.getElementsByTagName('head')[0],
		body = doc.getElementsByTagName('body')[0],
		sniff = /*@cc_on!@*/1 + /(?:Gecko|AppleWebKit)\/(\S*)/.test(navigator.userAgent); // 0 - IE, 1 - O, 2 - GK/WK

	var createNode = function(tag, attrs) {
		var attr, node = doc.createElement(tag);
		for (attr in attrs) {
			if (attrs.hasOwnProperty(attr)) {
				node.setAttribute(attr, attrs[attr]);
			}
		}
		return node;
	};

	var load = function(type, urls, callback, scope) {
		if (this == win) {
			return new load(type, urls, callback, scope);
		}

		urls = (typeof urls == 'string' ? [urls] : urls);
		scope = (scope ? (scope == 'body' ? body : head) : (type == 'js' ? body : head));

		this.callback = callback || function() {};
		this.queue = [];

		var node, i = len = 0, that = this;

		for (i = 0, len = urls.length; i < len; i++) {
			this.queue[i] = 1;
			if (type == 'css') {
				node = createNode('link', { type: 'text/css', rel: 'stylesheet', href: urls[i] });
			}
			else {
				node = createNode('script', { type: 'text/javascript', src: urls[i] });
			}
			scope.appendChild(node);

			if (sniff) {
				if (type == 'css' && sniff == 2) {
					var intervalID = setInterval(function() {
						try {
							node.sheet.cssRules;
							clearInterval(intervalID);
							that.__callback();
						}
						catch (ex) {}
					}, 100);
				}
				else {
					node.onload = function() {
						that.__callback();
					}
				}
			}
			else {
				node.onreadystatechange = function() {
					if (/^loaded|complete$/.test(this.readyState)) {
						this.onreadystatechange = null;
						that.__callback();
					}
				};
			}
		}

		return this;
	};
	load[proto].__callback = function() {
		if (this.queue.pop() && (this.queue == 0)) { this.callback(); }
	};

	window.Sid = {
		css: function(urls, callback, scope) {
			return load('css', urls, callback, scope);
		},
		js: function(urls, callback, scope) {
			return load('js', urls, callback, scope);
		},
		load: function(type, urls, callback, scope) {
			return load(type, urls, callback, scope);
		}
	};
})();

(function($) {
  $.fn.videoIcon = function () {
    return this.each (function (i) {
      var href = $(this).parent('a').attr('href');
      if(href.indexOf('video.zeit.de') > -1 && href.indexOf('#autoplay') < 0) {
         href += '#autoplay';
      }
      var imgclass = $(this).attr('class');
      $(this).removeClass().parent('a').wrap('<div class="imgbox ' + imgclass + '"> </div>').prepend('<span class="playimg"> </span>').attr('href', href );
    });
  };
}(jQuery));

(function ($) {
	$("body").addClass('body-js').addClass('fullwidth');

    if(typeof $.fn.videoIcon === 'function'){
      $('a[href^="http://video.zeit.de/video/"] img').videoIcon();
	  if(window.location.hostname == "video.zeit.de") $('a[href^="/video/"] img').videoIcon();
      $('a.playmedia img').videoIcon();
    }

	if(myagent.toLowerCase().indexOf('windows') > -1) {
		// nicht jedoch auf IE9 :P (das hamm wa nu davon)
		if(myagent.indexOf('MSIE 9') < 0) $("body").addClass('body-iswindows');
    }
	ZEIT.crunchCookies();
	if(window.Z_WT_KENNUNG !== undefined) console.info(Z_WT_KENNUNG);
	$('.cookieusername').each(function () {
		var t = $(this).text();
		$(this).text(decodeURIComponent(t));
	});
	window.ppath = ZEIT.preview();
    window.cpath = ZEIT.csspath();
	
    //cookie administration panel
    /*
    if($(".cookie_admin").size() > 0 ){
	
		Sid.js(ppath + 'plugins/jquery.cookieAdmin.js?' + window.actualversion, function() {
			 $(".cookie_admin").cookieAdmin();
		});
	
	}*/
    
	if($("#module_wahlen2011").size() > 0 || $(".modul_wahlticker_2011").size() > 0) {
		Sid.js(ppath + 'plugins/jquery.wahlen2011.js?' + window.actualversion, function() {
			$("#module_wahlen2011").wahlen2011( {type:"desktop"} );
			$(".modul_wahlticker_2011").wahlen2011( {type:"desktop"} );
		});	
	}
	if($('#zeit_frauenwmticker').size() > 0) {
		Sid.js(ppath + 'plugins/jquery.ticker.js?' + window.actualversion, function() {
			$('#zeit_frauenwmticker').ticker();
		});
	}
	
	if($("#zeit-readersarticle-my-form #edit-article").size() > 0 ) {
		Sid.js(ppath + 'plugins/jquery.formcounter.js?' + window.actualversion, function() {
			 $("#zeit-readersarticle-my-form #edit-article").formcounter();
		});
	}
	
	// navigation
	$('ul.mainnav li').hover( function(e) {
        $(this).addClass('act-current').children('ul').css({cursor: 'pointer'}).show();
        $(this).children('ul').css({cursor: 'pointer'}).show();
    }, function() {
        $(this).stop().removeClass('act-current').children('ul').hide();
    });
	
	// scripts depending colorbox
	Sid.js(ppath + 'plugins/jquery.colorbox.min.js', function(){
		if( $('.weather').size() > 0 ) Sid.js( ppath + 'plugins/jquery.wetterNet.js', function() {
			$('.weather').wetterNet();
		});	
		// delegate click events to the #wrapper if possible
		$('#wrapper').delegate("a#drupalregister,a#drupalformregister", "click", function() {
			$(this).colorbox({
	            iframe: true, 
	            width: 506, 
	            height: 632, 
	            opacity: 0.9, 
	            speed: 800, 
	            close: "Schliessen"
	        });
		}).delegate("a#drupalformlogin, a#drupallogin", "click", function() {
			$(this).colorbox({
	            iframe: true, 
	            width: 501, 
	            height: 470, 
	            opacity: 0.9,
	            resize: false,
	            speed: 800, 
	            close: "Schliessen",
	            title: " "
	        }, function() {
				$(this).bind('cbox_closed', function() {
					window.location.reload();
				});
			});
		}).delegate("a.colorbox", "click", function() {
			$(this).colorbox({
	            current : "{current}/{total}", 
	            transition: "elastic", 
	            maxWidth: "99%", 
	            maxHeight: "99%", 
	            opacity: 0.9, 
	            close : "Schliessen"
	        });
		}).delegate("a.meinestartseite", "click", function() {
			$(this).colorbox({
	            iframe: true,
				innerWidth: 690,
				innerHeight: 512,
				opacity: 0.9,
				speed: 800,
				close: "Schliessen",
				title: "So machen Sie ZEIT ONLINE zu Ihrer Startseite."
	        });
		}).delegate("a.drupalsendarticle", "click", function() {
			$(this).colorbox({
	            iframe: true,
				innerWidth: 474,
				innerHeight: 668,
				opacity: 0.9,
	            speed: 800, 
	            close: "Schliessen",
				scrolling: false,
				title: " "
	        });
		});
		$('#bottom').delegate(".footer2 a[href='#bildrechte']", "click", function(evt) {
			evt.preventDefault();
			$(this).colorbox({
	            inline:true,
	            href:"#bildrechte",
	            opacity: 0.9, 
	            resize: false,
	            speed: 800, 
	            close : "Schliessen",
	            title: "Bildrechte auf dieser Seite"
	        });
		});
		if($("a.colorpopup").size() > 0) Sid.js(ppath + 'plugins/jquery.colorpopup.js', function() {
			$("a.colorpopup").colorpopup();
		});
	}); // end scripts depending colorbox
	

	// scripts depending toolbox.flashembed
	if($('.zol_video').size() > 0 || $('.zol_titelfluss').size() > 0) Sid.js(ppath + 'plugins/toolbox.flashembed.js', function() {
		// brightcove video magic
		if($('.zol_video').size() > 0) Sid.js(ppath + 'plugins/jquery.video.js', function() {
			$('.zol_video').video();
		});
		// zeit title meta data plugin
		if($('.zol_titelfluss').size() > 0) Sid.js(ppath + 'plugins/jquery.titelfluss.js', function() {
			$('.zol_titelfluss').titelfluss();
		});
		// Videomosaic
		if($('#videomosaic').size() > 0) Sid.js(ppath + 'plugins/jquery.videoMosaic.js', function() {
			$('#videomosaic').videoMosaic();
		});		
	}); // end of scripts depending on jquery.jplayer.min

    if($('.zol_audio').size() > 0) Sid.js(ppath + 'plugins/jquery.jplayer.min.js', function() {
		// brightcove video magic
		if($('.zol_audio').size() > 0) Sid.js(ppath + 'plugins/jquery.audio.js', function() {
			$('.zol_audio').audio();
		});
	}); // end of scripts depending on jquery.jplayer.min
	if($('.infobox').size() > 0) Sid.js(ppath + 'plugins/jquery.infobox.js', function() {
		$('.infobox').infobox();
	});
	
	if($('#bottompic').size() > 0) Sid.js(ppath + 'plugins/jquery.bottompic.js', function() {
		$('#bottompic').bottompic();
	});

    if($('.zol_inlinelabel').size() > 0) Sid.js(ppath + 'plugins/jquery.inlinelabel.js', function() {
			$('.zol_inlinelabel').inlinelabel();
		});

	if($('#main.rankings').size() > 0) Sid.js(ppath + 'plugins/jquery.tabs.js', function() {
		$('#main.rankings').tabs();
	});

	if($('.savebookmark').size() > 0 || $('.bookmarkgallery').size() > 0 || $('.post .bookmark a:first').size() > 0) Sid.js(ppath + 'plugins/jquery.buts.js', function() {
		$('.savebookmark, .bookmarkgallery').buts();
		$('.post .bookmark a:first').buts({prefix: '<div class="bms"><div>', suffix: '</div><a href="#" id="bm_close">Schliessen</a></div>', parenttype: 'div.bookmark'});
	});
	
	if($('form.standardform').size() > 0 || $('.zol-accordion').size() > 0) {
		$('head').append($('<link rel="stylesheet" type="text/css" href="' + cpath + 'ui/smoothness/jquery-ui-1.8.9.custom.css" />'));
		$.getScript(ppath + 'libs/jquery-ui.min.js', function() {
			$('.date1 input').datepicker({
	            changeMonth: true,
	            changeYear: true,
	            currentText: 'Heute',
	            dateFormat: 'dd.mm.yy',
	            dayNamesMin: ['So', 'Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa'],
	            firstDay: 1,
	            inline: true,
	            maxDate: '+0',
	            minDate: new Date(1946, 2 - 1, 20),
	            monthNames: ['Januar','Februar','Märrz','April','Mai','Juni','Juli','August','September','Oktober','November','Dezember'],
	            monthNamesShort: ['Jan','Feb','Mrz','Apr','Mai','Jun','Jul','Aug','Sep','Okt','Nov','Dez'],
	            nextText: 'Vor',
	            prevText: 'Zurück',
	            yearRange: '1946:2020'
	        });



	        $('.date2 input').datepicker({
	            changeMonth: true,
	            changeYear: true,
	            currentText: 'Heute',
	            dateFormat: 'dd.mm.yy',
	            dayNamesMin: ['So', 'Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa'],
	            firstDay: 1,
	            inline: true,
	            maxDate: '+0',
	            minDate: new Date(1946, 2 - 1, 20),
	            monthNames: ['Januar','Februar','März','April','Mai','Juni','Juli','August','September','Oktober','November','Dezember'],
	            monthNamesShort: ['Jan','Feb','Mrz','Apr','Mai','Jun','Jul','Aug','Sep','Okt','Nov','Dez'],
	            nextText: 'Vor',
	            prevText: 'Zurück',
	            yearRange: '1946:2020'
	        });

			$("#wrapper").delegate('.daterange .date span.calIcon', "click", function() {
				$(this).prev('input').focus();
			}).delegate('input[name="q"]', 'focus', function(){
				$(this).select();
			});

            $(".zol-accordion").accordion({ header: ".header",autoHeight: false});
		});

       
	}
	
	if($('.body-gallery').size() > 0 || $('.inlinebiga').size() > 0) Sid.js(ppath + 'plugins/jquery.gallery.js', function() {
		$('.body-gallery #main').gallery();
		$('.inlinebiga').gallery({inline: true});
	});
	
	if($('.timeline').size() > 0) Sid.js(ppath + 'plugins/jquery.timeline.js', function() {
		$('.timeline').timeline();
	});

	if($('.newcomments').size() > 0) Sid.js(ppath + 'plugins/jquery.comments.js', function() {
		$('.newcomments').comments();
	});

	if($('.quizform').size() > 0 || $('.quiz').size() > 0) Sid.js(ppath + 'plugins/jquery.quizSend.js', function() {
		$('.quizform').quizSend();
		$('.quiz form').quizSend();
	});
	
	if($('.zeitkommentare').size() > 0) Sid.js(ppath + 'plugins/jquery.comNav.js', function() {
		$('.zeitkommentare .pagenav').comNav();
	});

	if($('#header').size() > 0 && $('.newsflash').size() < 1) Sid.js(ppath + 'plugins/jquery.eilmeldung.js', function() {
		$('#header').eilmeldung({debug:ZEIT.getQueryVar('bndebug')});
	});
	
	// Bytefm Player
	$('.bytefm_player').click( function() {
		window.open( $(this).attr('href'), 'ByteFM-Player', 'width=220,height=500' );
		return false;
	});
	$('.dlf_player').click( function() {
		window.open( $(this).attr('href'), 'DLF-Player', 'width=640,height=445' );
		return false;
	});

	if($('a.bytefm_player img').size() > 0) {
		$('a.bytefm_player img').parent().addClass('bytefmplayer_js');
	}
	if($('a.dlf_player img').size() > 0) {
		$('a.dlf_player img').parent().addClass('dlfplayer_js');
	}
	if($('img[src $=static/img/player_0001_normal.jpg]')) {
		$('img[src $=static/img/player_0001_normal.jpg]').wrap('<div class="bytefmbigplayer_js></div>');
	}

	// delegate the logout action
	$("#wrapper").delegate("a#logout", "click", function(evt) {
        evt.preventDefault();
		ZEIT.cookieErase('drupal-userid');
		ZEIT.cookieErase('drupal-username');
		ZEIT.cookieErase('drupal-useradmin');
		ZEIT.cookieErase('drupal-author');
        var i = $('<iframe></iframe>').css({height: "1px", width: "1px", position: "absolute", left: "-5000em", top: "-5000em", border: "none"});
        $(i).appendTo('body');
        $(i).attr('src','http://community.zeit.de/logout');
		// falls das Sessioncookie noch da ist, weg damit
		var sessname = ZEIT.cookieSearchName('SESS');
		if(sessname !== null) {
			ZEIT.cookieErase(sessname);
		}
        window.setTimeout(function(){window.location.reload();}, 2000);
    });

	Sid.js(ppath + 'plugins/jquery.iPadLink.js?' + window.actualversion, function() {
		if(window.is_overridden_tablet===true) $("#bottom .footer2 .center").iPadLink({ forcetablet: "on", text: "Tablet-Version" });
	});
	
})(jQuery);